#!/usr/bin/env ruby
# requiring IMOD for "header" command
# Draw a polygon by placing points on the tomogram using 3dmod and save it as a model file.
# This program will place points within the polygon at specified intervals.
# usage polygon2.rb polygon.mod tomo.mrc (optional: output.mod)
# output polygon_inside.mod

step = 10 #putting points at #{step}-pixel intervals

file = ARGV[0].split(/\./)[0] # input polygon.mod
ext = ARGV[0].split(/\./)[1]
if ext == "mod"
  system("model2point -input #{ARGV[0]} -output #{file}.txt")
  a = File.open("#{file}.txt","r")
else
  a = File.open(ARGV[0],"r")
end

if ARGV[2] # output filename
  outfile = ARGV[1].split(/\./)[0]
  output = "#{outfile}.txt"
  outmod = "#{outfile}.mod"
else
  output = "#{file}_inside.txt"
  outmod = "#{file}_inside.mod"
end
out = File.open(output,"w")

system("header #{ARGV[1]} > header.txt") # requires IMOD

header = File.open("header.txt","r")

while line = header.gets
  line =~ /Number of columns/
  if $&
    h_array = line.split(/\s+/)
    mrcx = h_array[7].to_i
    mrcy = h_array[8].to_i
    p h_array
  end
end

header.close

#read polygon.mod
polygon_point = []
while line = a.gets

  b = line.split(/\s/)
  
  b.delete("")

  if b.size > 3
    printf("error!\n")
    exit
  else
    polygon_point.push([b[0].to_f,b[1].to_f,b[2].to_f])
  end
end
polygon_point.push(polygon_point[0]) # add first point to the last

#=====

def_point = []
numx = (mrcx/step).floor
numy = (mrcy/step).floor

for i in 1...numx
  px = (i * step).to_f + 0.1
  for j in 1..numy
    py = (j * step).to_f + 0.1
    cross = 0
    for k in 0...polygon_point.size - 1
      poly_x1 = polygon_point[k][0].to_f
      poly_y1 = polygon_point[k][1].to_f
      poly_z1 = polygon_point[k][2].to_f
      poly_x2 = polygon_point[k+1][0].to_f
      poly_y2 = polygon_point[k+1][1].to_f
      poly_z2 = polygon_point[k+1][2].to_f
      
      slope = (poly_y2 - poly_y1) / (poly_x2 - poly_x1)
      intercept = poly_y2 - (slope * poly_x2)
      
      if poly_x2 < poly_x1
        rangeX = (poly_x2..poly_x1)
      else
        rangeX = (poly_x1..poly_x2)
      end

      if poly_y2 < poly_y1
        rangeY = (poly_y2..poly_y1)
      else
        rangeY = (poly_y1..poly_y2)
      end

      if rangeY.cover?(py)
        interX = (py - intercept) / slope
        if rangeX.cover?(interX)
          if interX > px + 1
                cross += 1
          end
        end
      end
    end
    
    if cross%2 > 0
      printf("%5d%5d%5d%5d\n",px,py,poly_z2,cross)
      out.printf("%7d%7d%7d\n",px,py,poly_z2)
    end

  end
end
#====

out.close
system("point2model -input #{output} -output #{outmod}")

